---@meta

---@class FB1ModManagerSetting
---@field ModOrder TMap<FString, int32>
---@field ModDirectory FString
local FB1ModManagerSetting = {}



---@class UB1Mod : UObject
local UB1Mod = {}

---@return boolean
function UB1Mod:IsEnabled() end
---@return FString
function UB1Mod:GetRootPath() end
---@return FString
function UB1Mod:GetPakPath() end
---@return FString
function UB1Mod:GetModMetaVersion() end
---@return FString
function UB1Mod:GetModMetaUrl() end
---@return FString
function UB1Mod:GetModMetaProjectName() end
---@return FString
function UB1Mod:GetModMetaDescription() end
---@return TArray<FString>
function UB1Mod:GetModMetaDependencies() end
---@return FString
function UB1Mod:GetModMetaAuthorName() end
---@return FString
function UB1Mod:GetModContentPath() end
---@return TArray<FString>
function UB1Mod:GetAssetPaths() end
---@return FString
function UB1Mod:GetAssetLocation() end


---@class UB1ModSystemManager : UGameInstanceSubsystem
---@field ModManagerSetting FB1ModManagerSetting
---@field ModList TMap<FString, UB1Mod>
local UB1ModSystemManager = {}

---@return TMap<FString, UB1Mod>
function UB1ModSystemManager:GetModList() end
---@return TArray<FString>
function UB1ModSystemManager:GetEnabledJsonAssetPaths() end


---@class UB1PakLibrary : UBlueprintFunctionLibrary
local UB1PakLibrary = {}

---@param InWorldContextObject UObject
function UB1PakLibrary:UpdateTexture(InWorldContextObject) end
---@param InWorldContextObject UObject
---@param InRootPath FString
---@param InContentPath FString
function UB1PakLibrary:UnRegisterMountPoint(InWorldContextObject, InRootPath, InContentPath) end
---@param InWorldContextObject UObject
---@param InPakFilename FString
---@return boolean
function UB1PakLibrary:UnmountPak(InWorldContextObject, InPakFilename) end
---@param InWorldContextObject UObject
---@param InPakPackage FString
function UB1PakLibrary:UnloadPackages(InWorldContextObject, InPakPackage) end
---@param InWorldContextObject UObject
---@param InRootPath FString
---@param InContentPath FString
function UB1PakLibrary:RegisterMountPoint(InWorldContextObject, InRootPath, InContentPath) end
---@param InWorldContextObject UObject
---@param InPakFilename FString
---@param InMountPath FString
---@return boolean
function UB1PakLibrary:MountPak(InWorldContextObject, InPakFilename, InMountPath) end
---@param InWorldContextObject UObject
---@param InPakFilename FString
---@param OutPakSize int64
---@return boolean
function UB1PakLibrary:IsValidPakFile(InWorldContextObject, InPakFilename, OutPakSize) end
---@param InWorldContextObject UObject
---@param InFilename FString
---@return UTexture
function UB1PakLibrary:GetTextureAsset(InWorldContextObject, InFilename) end
---@param InWorldContextObject UObject
---@param InFilename FString
---@return UStaticMesh
function UB1PakLibrary:GetStaticMesh(InWorldContextObject, InFilename) end
---@param InWorldContextObject UObject
---@param InFilename FString
---@return USkeletalMesh
function UB1PakLibrary:GetSkeletalMesh(InWorldContextObject, InFilename) end
---@param InWorldContextObject UObject
---@return TArray<FString>
function UB1PakLibrary:GetMountedPakFilenames(InWorldContextObject) end
---@param InWorldContextObject UObject
---@param InFilename FString
---@return UMaterial
function UB1PakLibrary:GetMaterialAsset(InWorldContextObject, InFilename) end
---@param InWorldContextObject UObject
---@param InFilename FString
---@return UJsonModDataAsset
function UB1PakLibrary:GetJsonDataAsset(InWorldContextObject, InFilename) end
---@param InWorldContextObject UObject
---@param InPakDirectory FString
---@param bRecursively boolean
---@return TArray<FString>
function UB1PakLibrary:GetFilesInPakDirectory(InWorldContextObject, InPakDirectory, bRecursively) end
---@param InWorldContextObject UObject
---@param InPakFilename FString
---@param bUAssetOnly boolean
---@return TArray<FString>
function UB1PakLibrary:GetFilesInPak(InWorldContextObject, InPakFilename, bUAssetOnly) end
---@param InWorldContextObject UObject
---@param InPakDirectory FString
---@return boolean
function UB1PakLibrary:DirectoryExists(InWorldContextObject, InPakDirectory) end
---@param InWorldContextObject UObject
---@param InRootPath FString
---@param InContentPath FString
function UB1PakLibrary:CleanupForUnMount(InWorldContextObject, InRootPath, InContentPath) end


---@class UB1PakMountSubsystem : UGameInstanceSubsystem
local UB1PakMountSubsystem = {}


